VERSION 5.00
Begin VB.UserControl ucLitleListView 
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   240
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   320
End
Attribute VB_Name = "ucLitleListView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'Esta es una pequea versin de este usercontrol "http://www.leandroascierto.com.ar/foro/index.php?topic=731.0"
'El cual se extrajo solo las partes requeridas para este proyecto.
Private Declare Function DestroyWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function CreateWindowEx Lib "user32.dll" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByRef lpParam As Any) As Long
Private Declare Function SetWindowPos Lib "user32.dll" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Private Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByRef lParam As Any) As Long
Private Declare Function GetFocus Lib "user32.dll" () As Long
Private Declare Function SetFocus Lib "user32.dll" (ByVal hwnd As Long) As Long

Private Type LV_COLUMN
    mask            As Long
    fmt             As Long
    cx              As Long
    pszText         As String
    cchTextMax      As Long
    iSubItem        As Long
    iImage          As Long
    iOrder          As Long
End Type

Private Type LVITEM
    mask       As Long
    iItem      As Long
    iSubItem   As Long
    State      As Long
    stateMask  As Long
    pszText    As String
    cchTextMax As Long
    iImage     As Long
    lParam     As Long
    iIndent    As Long
End Type

Public Enum AlignConsts
    LVCFMT_LEFT = &H0
    LVCFMT_RIGHT = &H1
    LVCFMT_CENTER = &H2
End Enum

Private Const LVCF_FMT              As Long = &H1
Private Const LVCF_TEXT             As Long = &H4
Private Const LVCF_WIDTH            As Long = &H2

Private Const LVIF_TEXT             As Long = &H1
Private Const LVIF_PARAM            As Long = &H4
Private Const LVIF_STATE            As Long = &H8

Private Const LVIS_SELECTED         As Long = &H2
Private Const LVIS_FOCUSED          As Long = &H1

Private Const LVS_EX_FULLROWSELECT  As Long = &H20

Private Const LVS_REPORT            As Long = &H1
Private Const LVS_SINGLESEL         As Long = &H4
Private Const LVS_SHOWSELALWAYS     As Long = &H8

Private Const LVNI_SELECTED         As Long = &H2
Private Const LVNI_FOCUSED          As Long = &H1

Private Const LVM_FIRST             As Long = &H1000
Private Const LVM_GETITEMCOUNT      As Long = (LVM_FIRST + 4)
Private Const LVM_GETITEMA          As Long = (LVM_FIRST + 5)
Private Const LVM_SETITEMA          As Long = (LVM_FIRST + 6)
Private Const LVM_INSERTITEMA       As Long = (LVM_FIRST + 7)
Private Const LVM_DELETEITEM        As Long = (LVM_FIRST + 8)
Private Const LVM_DELETEALLITEMS    As Long = (LVM_FIRST + 9)
Private Const LVM_GETNEXTITEM       As Long = (LVM_FIRST + 12)
Private Const LVM_INSERTCOLUMNA     As Long = (LVM_FIRST + 27)
Private Const LVM_SETITEMSTATE      As Long = (LVM_FIRST + 43)
Private Const LVM_GETITEMTEXTA      As Long = (LVM_FIRST + 45)
Private Const LVM_SETITEMTEXTA      As Long = (LVM_FIRST + 46)

Private Const LVM_SETEXTENDEDLISTVIEWSTYLE As Long = (LVM_FIRST + 54)
Private Const LVM_GETEXTENDEDLISTVIEWSTYLE As Long = (LVM_FIRST + 55)

Private Const WS_TABSTOP            As Long = &H10000
Private Const WS_BORDER             As Long = &H800000
Private Const WS_VISIBLE            As Long = &H10000000
Private Const WS_CHILD              As Long = &H40000000
                    
Private Const SWP_NOMOVE            As Long = &H2
Private Const SWP_NOOWNERZORDER     As Long = &H200
Private Const SWP_NOZORDER          As Long = &H4

Private m_hListView As Long

Private Sub UserControl_GotFocus()
    SetFocus m_hListView
End Sub

Private Sub UserControl_Initialize()
    Dim lLVStyle As Long
    lLVStyle = WS_CHILD Or WS_TABSTOP Or WS_BORDER Or WS_VISIBLE Or LVS_REPORT Or LVS_SINGLESEL Or LVS_SHOWSELALWAYS
    m_hListView = CreateWindowEx(0&, "SysListView32", vbNullString, lLVStyle, 0&, 0&, UserControl.ScaleWidth, UserControl.ScaleHeight, UserControl.hwnd, 0&, App.hInstance, ByVal 0&)
End Sub

Private Sub UserControl_Resize()
    Call SetWindowPos(m_hListView, 0&, 0&, 0&, UserControl.ScaleWidth, UserControl.ScaleHeight, SWP_NOZORDER Or SWP_NOOWNERZORDER Or SWP_NOMOVE)
End Sub

Private Sub UserControl_Terminate()
    If m_hListView Then DestroyWindow m_hListView
End Sub

Function ColumnAdd(ByVal Index As Long, ByVal Caption As String, ByVal Width As Long, Optional ByVal Align As AlignConsts = LVCFMT_LEFT) As Boolean
    Static llCount As Long
    
    Dim LVC As LV_COLUMN
    
    With LVC
        .mask = LVCF_FMT Or LVCF_TEXT Or LVCF_WIDTH
        .pszText = Caption
        .cchTextMax = Len(Caption)
        .fmt = Align
        .cx = Width
    End With

    Call SendMessage(m_hListView, LVM_INSERTCOLUMNA, Index, LVC)

End Function

Public Function ItemAdd(ByVal Item As Long, ByVal Text As String, Optional ByVal lngItemData As Long) As Boolean
    Dim uLVI As LVITEM

    With uLVI
        .iItem = Item
        .pszText = Text
        .cchTextMax = Len(Text)
        .mask = LVIF_TEXT Or LVIF_PARAM
        .lParam = lngItemData
    End With
    
    ItemAdd = (SendMessage(m_hListView, LVM_INSERTITEMA, 0&, uLVI) > -1)
        
End Function

Public Function ItemRemove(ByVal Item As Long) As Boolean
    ItemRemove = CBool(SendMessage(m_hListView, LVM_DELETEITEM, Item, ByVal 0&))
End Function

Public Function SetItemText(ByVal Item As Long, ByVal SubItem As Long, ByVal Text As String) As Boolean
    Dim uLVI As LVITEM

    With uLVI
        .iItem = Item
        .iSubItem = SubItem
        .pszText = Text
        .cchTextMax = Len(Text)
        .mask = LVIF_TEXT
    End With
    
    SetItemText = CBool(SendMessage(m_hListView, LVM_SETITEMA, 0&, uLVI))
    
End Function

Public Function GetItemText(ByVal Item As Long, Optional ByVal SubItem As Long = 0) As String
    Dim uLVI As LVITEM

    With uLVI
        .iItem = Item
        .iSubItem = SubItem
        .pszText = String(260, 0)
        .cchTextMax = 260
        .mask = LVIF_TEXT
    End With
    
    If SendMessage(m_hListView, LVM_GETITEMA, 0&, uLVI) Then
        GetItemText = Left$(uLVI.pszText, InStr(uLVI.pszText, Chr$(0)) - 1)
    End If
End Function

Public Property Let ItemData(ByVal Item As Long, ByVal lngItemData As Long)
    Dim uLVI As LVITEM

    With uLVI
        .iItem = Item
        .lParam = lngItemData
        .mask = LVIF_PARAM
    End With
    
    Call SendMessage(m_hListView, LVM_SETITEMA, 0&, uLVI)
End Property

Public Property Get ItemData(ByVal Item As Long) As Long
    Dim uLVI As LVITEM

    With uLVI
        .iItem = Item
        .mask = LVIF_PARAM
    End With
    
    Call SendMessage(m_hListView, LVM_GETITEMA, 0&, uLVI)
    
    ItemData = uLVI.lParam
    
End Property

Public Function GetSelectedItem() As Long
    Dim lFlags As Long
    lFlags = LVNI_SELECTED
    If GetFocus() = m_hListView Then lFlags = lFlags Or LVNI_FOCUSED
    GetSelectedItem = SendMessage(m_hListView, LVM_GETNEXTITEM, &HFFFF, ByVal lFlags)
End Function

Public Function SetSelectedItem(ByVal Item As Long)
    Dim uLVI As LVITEM

    With uLVI
        .stateMask = LVIS_SELECTED Or LVIS_FOCUSED
        .State = LVIS_SELECTED Or LVIS_FOCUSED
        .mask = LVIF_STATE
    End With
    Call SendMessage(m_hListView, LVM_SETITEMSTATE, Item, uLVI)
 
End Function

Public Function Clear() As Boolean
    Clear = CBool(SendMessage(m_hListView, LVM_DELETEALLITEMS, 0&, ByVal 0&))
End Function

Public Property Get GetItemCount() As Long
    GetItemCount = SendMessage(m_hListView, LVM_GETITEMCOUNT, 0&, ByVal 0&)
End Property

Public Function FullRowSelect(ByVal Value As Boolean)
    If Value Then
        Call pvSetExStyle(pvGetExStyle Or LVS_EX_FULLROWSELECT)
    Else
        Call pvSetExStyle(pvGetExStyle And Not LVS_EX_FULLROWSELECT)
    End If
End Function

Private Function pvSetExStyle(ByVal lExStyle As Long)
    Call SendMessage(m_hListView, LVM_SETEXTENDEDLISTVIEWSTYLE, 0&, ByVal lExStyle)
End Function

Private Function pvGetExStyle()
    pvGetExStyle = SendMessage(m_hListView, LVM_GETEXTENDEDLISTVIEWSTYLE, 0&, ByVal 0&)
End Function
